<?php
namespace local_adminmfa;

defined('MOODLE_INTERNAL') || die();

class observer {

    /**
     * Executado quando o usuário faz login.
     */
    public static function on_user_login($event) {
        global $DB;

        $userid = $event->userid;

        if (is_siteadmin($userid)) {
            if ($DB->record_exists('tool_mfa', ['userid' => $userid])) {
                $DB->set_field('tool_mfa', 'lastverified', null, ['userid' => $userid]);
                $DB->set_field('tool_mfa', 'revoked', 0, ['userid' => $userid]);
            }
        } else {
            $DB->delete_records('tool_mfa', ['userid' => $userid]);
        }

        return true;
    }
}
